using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmExceptionReport
	/// </summary>
	public class FrmExceptionReport : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.Button btnPrint;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.Button btnClose;
        private System.Windows.Forms.PrintDialog printDialog1;
        private gov.va.med.vbecs.GUI.controls.VbecsReportViewer rvExceptionReport;
		private System.ComponentModel.IContainer components = null;
        Hashtable _exceptionReports;

		/// <summary>
		/// Constrcutor
		/// </summary>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		/// <param name="exceptionReports"></param>
		public FrmExceptionReport(DateTime startDate, DateTime endDate, Hashtable exceptionReports)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC082.FrmExceptionReport());
			//
            BOL.VbecsReport.SetUpReportButtons(this.rvExceptionReport);
            _exceptionReports = exceptionReports;
            //
			LoadExceptionReport(startDate, endDate, exceptionReports);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmExceptionReport));
            this.btnClose = new System.Windows.Forms.Button();
            this.btnPrint = new System.Windows.Forms.Button();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.picImage = new System.Windows.Forms.PictureBox();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            this.rvExceptionReport = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(742, 30);
            this.vbecsLogo1.TabIndex = 3;
            this.vbecsLogo1.Title = "Exception Report";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 509);
            this.lblRequiredField.TabIndex = 5;
            // 
            // btnClose
            // 
            this.btnClose.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnClose.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnClose.Location = new System.Drawing.Point(664, 500);
            this.btnClose.Name = "btnClose";
            this.btnClose.Size = new System.Drawing.Size(75, 23);
            this.btnClose.TabIndex = 2;
            this.btnClose.Text = "&Close";
            this.btnClose.Click += new System.EventHandler(this.btnClose_Click);
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrint.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(584, 500);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(75, 23);
            this.btnPrint.TabIndex = 1;
            this.btnPrint.Text = "&Print";
            this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.picImage);
            this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grpImage.Location = new System.Drawing.Point(4, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 464);
            this.grpImage.TabIndex = 4;
            this.grpImage.TabStop = false;
            // 
            // picImage
            // 
            this.picImage.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
            this.picImage.Location = new System.Drawing.Point(4, 12);
            this.picImage.Name = "picImage";
            this.picImage.Size = new System.Drawing.Size(45, 45);
            this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picImage.TabIndex = 0;
            this.picImage.TabStop = false;
            // 
            // printDialog1
            // 
            this.printDialog1.AllowPrintToFile = false;
            // 
            // rvExceptionReport
            // 
            this.rvExceptionReport.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvExceptionReport.Location = new System.Drawing.Point(59, 37);
            this.rvExceptionReport.Name = "rvExceptionReport";
            this.rvExceptionReport.Size = new System.Drawing.Size(680, 457);
            this.rvExceptionReport.TabIndex = 6;
            this.rvExceptionReport.RenderingComplete += new Microsoft.Reporting.WinForms.RenderingCompleteEventHandler(this.rvExceptionReport_RenderingComplete);
            this.rvExceptionReport.RenderingBegin += new System.ComponentModel.CancelEventHandler(this.rvExceptionReport_RenderingBegin);
            // 
            // FrmExceptionReport
            // 
            this.AcceptButton = this.btnPrint;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnClose;
            this.ClientSize = new System.Drawing.Size(742, 523);
            this.Controls.Add(this.rvExceptionReport);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.btnClose);
            this.Controls.Add(this.btnPrint);
            this.hlphelpChm.SetHelpKeyword(this, "Exception_Report.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.Name = "FrmExceptionReport";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Exception Report";
            this.Load += new System.EventHandler(this.FrmExceptionReport_Load);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.btnPrint, 0);
            this.Controls.SetChildIndex(this.btnClose, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.rvExceptionReport, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picImage)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

	
		private void LoadExceptionReport(DateTime startDate, DateTime endDate, Hashtable exceptionReports)
		{
            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(ThisUser.UserName);

            string reportCriteria = "Date Range: ";
            reportCriteria += Common.VBECSDateTime.FormatDateString(startDate);
            reportCriteria += " - ";
            reportCriteria += Common.VBECSDateTime.FormatDateString(endDate);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter(reportCriteria);

            ReportDataSource reportSourceMain = new ReportDataSource();
            if (exceptionReports[Common.ExceptionReportType.ExceptionReportMain] != null &&
                ((DataSet)exceptionReports[Common.ExceptionReportType.ExceptionReportMain]).Tables.Count > 0)
            {
                reportSourceMain.Name = "ExceptionMainDataSet";
                reportSourceMain.Value = ((DataSet)exceptionReports[Common.ExceptionReportType.ExceptionReportMain]).Tables[0];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            } 
            
            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionReport.rdlc");
            Stream streamExceptionQC = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionQC.rdlc");
            Stream streamExceptionQCInactivated = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionQCInactivated.rdlc");
            Stream streamExceptionQCNotPerformed = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionQCNotPerformed.rdlc");
            Stream streamExceptionEmergencyIssueOrder = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionEmergencyIssueOrder.rdlc");
            Stream streamExceptionQuarantine = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionQuarantine.rdlc");
            Stream streamExceptionReflexTest = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionReflexTest.rdlc");
            Stream streamExceptionSpecimen = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionSpecimen.rdlc");
            Stream streamExceptionPatientAboRh = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionPatientAboRh.rdlc");
            Stream streamExceptionPatientAboRhDiscrepancy = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionPatientAboRhDiscrepancy.rdlc");
            Stream streamExceptionPatientAntigenDiscrepancy = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionPatientAntigenDiscrepancy.rdlc");
            Stream streamExceptionPatientTest = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionPatientTest.rdlc");
            Stream streamExceptionPatientTestInactivated = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionPatientTestInactivated.rdlc");
            Stream streamExceptionUnitAboRh = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionUnitAboRh.rdlc");
            Stream streamExceptionUnitModification = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionUnitModification.rdlc");
            Stream streamExceptionUnitSelection = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionUnitSelection.rdlc");
            Stream streamExceptionLabelMismatch = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionLabelMismatch.rdlc");
            Stream streamExceptionCautionTagBTRFPrinting = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionCautionTagBTRFPrinting.rdlc");
            Stream streamExceptionTrwSpecimen = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionTrwSpecimen.rdlc");
            Stream streamExceptionTransfusionReactionWorkup = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionTransfusionReactionWorkup.rdlc");
            Stream streamExceptionAntigenTest = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionAntigenTest.rdlc");
            Stream streamExceptionUnitTest = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionUnitTest.rdlc");
            Stream streamExceptionReturnIssuedUnit = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionReturnIssuedUnit.rdlc");
            Stream streamExceptionTransfusion = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionTransfusion.rdlc");
            Stream streamExceptionUnitSupply = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionUnitSupply.rdlc");
            Stream streamExceptionExpiredUnit = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionExpiredUnit.rdlc");
            Stream streamExceptionUnitIssue = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionUnitIssue.rdlc");
            Stream streamExceptionPatientRestriction = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionPatientRestriction.rdlc");
            Stream streamExceptionUnitERIssuedTestingProblem = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionUnitERIssuedTestingProblem.rdlc");
            Stream streamExceptionExpiredOrder = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionExpiredOrder.rdlc");
            Stream streamExceptionRemoveFinalUnitStatus = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionRemoveFinalUnitStatus.rdlc");
            Stream streamExceptionInconclusiveCrossmatch = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionInconclusiveCrossmatch.rdlc");
            Stream streamExceptionElectronicTransfusion = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.ExceptionReport.ExceptionElectronicTransfusion.rdlc");
           // LocalReport report = new LocalReport();

            this.rvExceptionReport.LocalReport.SubreportProcessing += new SubreportProcessingEventHandler(LoadSubreportsEventHandler);

            this.rvExceptionReport.LocalReport.DataSources.Add(reportSourceMain);
            this.rvExceptionReport.LocalReport.DataSources.Add(reportSourceHeader);
            this.rvExceptionReport.LocalReport.DataSources.Add(reportSourceFooter);
            this.rvExceptionReport.LocalReport.LoadReportDefinition(stream);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionQC", streamExceptionQC);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionQCInactivated", streamExceptionQCInactivated);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionQCNotPerformed", streamExceptionQCNotPerformed);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionEmergencyIssueOrder", streamExceptionEmergencyIssueOrder);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionQuarantine", streamExceptionQuarantine);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionReflexTest", streamExceptionReflexTest);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionSpecimen", streamExceptionSpecimen);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionPatientAboRh", streamExceptionPatientAboRh);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionPatientAboRhDiscrepancy", streamExceptionPatientAboRhDiscrepancy);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionPatientAntigenDiscrepancy", streamExceptionPatientAntigenDiscrepancy);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionPatientTest", streamExceptionPatientTest);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionPatientTestInactivated", streamExceptionPatientTestInactivated);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionUnitAboRh", streamExceptionUnitAboRh);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionUnitModification", streamExceptionUnitModification);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionUnitSelection", streamExceptionUnitSelection);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionLabelMismatch", streamExceptionLabelMismatch);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionCautionTagBTRFPrinting", streamExceptionCautionTagBTRFPrinting);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionTrwSpecimen", streamExceptionTrwSpecimen);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionTransfusionReactionWorkup", streamExceptionTransfusionReactionWorkup);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionAntigenTest", streamExceptionAntigenTest);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionUnitTest", streamExceptionUnitTest);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionReturnIssuedUnit", streamExceptionReturnIssuedUnit);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionTransfusion", streamExceptionTransfusion);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionUnitSupply", streamExceptionUnitSupply);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionExpiredUnit", streamExceptionExpiredUnit);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionUnitIssue", streamExceptionUnitIssue);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionPatientRestriction", streamExceptionPatientRestriction);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionUnitERIssuedTestingProblem", streamExceptionUnitERIssuedTestingProblem);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionExpiredOrder", streamExceptionExpiredOrder);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionRemoveFinalUnitStatus", streamExceptionRemoveFinalUnitStatus);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionInconclusiveCrossmatch", streamExceptionInconclusiveCrossmatch);
            this.rvExceptionReport.LocalReport.LoadSubreportDefinition("ExceptionElectronicTransfusion", streamExceptionElectronicTransfusion);

            if (endDate.Date.Equals(BOL.VBECSDateTime.GetDivisionCurrentDateTime().Date))
            {
                this.rvExceptionReport.LocalReport.SetParameters(new ReportParameter("PreliminaryReport", "true"));
            }
            else
            {
                this.rvExceptionReport.LocalReport.SetParameters(new ReportParameter("PreliminaryReport", "false"));
            }

            this.rvExceptionReport.RefreshReport();
		}

        private void LoadSubreportsEventHandler(object sender, SubreportProcessingEventArgs e)
        {
            if (e.ReportPath == "ExceptionQC" || e.DataSourceNames[0].ToString() == "ExceptionQCDataSet")
            {
                ReportDataSource reportSourceExceptionQC = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportQC] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportQC]).Tables.Count > 0)
                {
                    reportSourceExceptionQC.Name = "ExceptionQCDataSet";
                    reportSourceExceptionQC.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportQC]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionQC);
            }
            else if (e.ReportPath == "ExceptionQCInactivated" || e.DataSourceNames[0].ToString() == "ExceptionQCInactivatedDataSet")
            {
                ReportDataSource reportSourceExceptionQCInactivated = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportQCInactivated] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportQCInactivated]).Tables.Count > 0)
                {
                    reportSourceExceptionQCInactivated.Name = "ExceptionQCInactivatedDataSet";
                    reportSourceExceptionQCInactivated.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportQCInactivated]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionQCInactivated);
            }
            else if (e.ReportPath == "ExceptionQCNotPerformed" || e.DataSourceNames[0].ToString() == "ExceptionQCNotPerformedDataSet")
            {
                ReportDataSource reportSourceExceptionQCNotPerformed = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportQCNotPerformed] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportQCNotPerformed]).Tables.Count > 0)
                {
                    reportSourceExceptionQCNotPerformed.Name = "ExceptionQCNotPerformedDataSet";
                    reportSourceExceptionQCNotPerformed.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportQCNotPerformed]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionQCNotPerformed);
            }
            else if (e.ReportPath == "ExceptionEmergencyIssueOrder" || e.DataSourceNames[0].ToString() == "ExceptionEmergencyIssueOrderDataSet")
            {
                ReportDataSource reportSourceExceptionEmergencyIssueOrder = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportEmergencyIssueOrder] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportEmergencyIssueOrder]).Tables.Count > 0)
                {
                    reportSourceExceptionEmergencyIssueOrder.Name = "ExceptionEmergencyIssueOrderDataSet";
                    reportSourceExceptionEmergencyIssueOrder.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportEmergencyIssueOrder]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionEmergencyIssueOrder);
            }
            else if (e.ReportPath == "ExceptionQuarantine" || e.DataSourceNames[0].ToString() == "ExceptionQuarantineDataSet")
            {
                ReportDataSource reportSourceExceptionQuarantine = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportQuarantine] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportQuarantine]).Tables.Count > 0)
                {
                    reportSourceExceptionQuarantine.Name = "ExceptionQuarantineDataSet";
                    reportSourceExceptionQuarantine.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportQuarantine]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionQuarantine);
            }
            else if (e.ReportPath == "ExceptionReflexTest" || e.DataSourceNames[0].ToString() == "ExceptionReflexTestDataSet")
            {
                ReportDataSource reportSourceExceptionReflexTest = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportReflexTest] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportReflexTest]).Tables.Count > 0)
                {
                    reportSourceExceptionReflexTest.Name = "ExceptionReflexTestDataSet";
                    reportSourceExceptionReflexTest.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportReflexTest]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionReflexTest);
            }
            else if (e.ReportPath == "ExceptionSpecimen" || e.DataSourceNames[0].ToString() == "ExceptionSpecimenDataSet")
            {
                ReportDataSource reportSourceExceptionSpecimen = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportSpecimen] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportSpecimen]).Tables.Count > 0)
                {
                    reportSourceExceptionSpecimen.Name = "ExceptionSpecimenDataSet";
                    reportSourceExceptionSpecimen.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportSpecimen]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionSpecimen);
            }
            else if (e.ReportPath == "ExceptionPatientAboRh" || e.DataSourceNames[0].ToString() == "ExceptionPatientAboRhDataSet")
            {
                ReportDataSource reportSourceExceptionPatientAboRh = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportPatientAboRh] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportPatientAboRh]).Tables.Count > 0)
                {
                    reportSourceExceptionPatientAboRh.Name = "ExceptionPatientAboRhDataSet";
                    reportSourceExceptionPatientAboRh.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportPatientAboRh]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionPatientAboRh);
            }
            else if (e.ReportPath == "ExceptionPatientAboRhDiscrepancy" || e.DataSourceNames[0].ToString() == "ExceptionPatientAboRhDiscrepancyDataSet")
            {
                ReportDataSource reportSourceExceptionPatientAboRhDiscrepancy = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportPatientAboRhDiscrepancy] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportPatientAboRhDiscrepancy]).Tables.Count > 0)
                {
                    reportSourceExceptionPatientAboRhDiscrepancy.Name = "ExceptionPatientAboRhDiscrepancyDataSet";
                    reportSourceExceptionPatientAboRhDiscrepancy.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportPatientAboRhDiscrepancy]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionPatientAboRhDiscrepancy);
            }
            else if (e.ReportPath == "ExceptionPatientAntigenDiscrepancy" || e.DataSourceNames[0].ToString() == "ExceptionPatientAntigenDiscrepancyDataSet")
            {
                ReportDataSource reportSourceExceptionPatientAntigenDiscrepancy = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportPatientAntigenDiscrepancy] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportPatientAntigenDiscrepancy]).Tables.Count > 0)
                {
                    reportSourceExceptionPatientAntigenDiscrepancy.Name = "ExceptionPatientAntigenDiscrepancyDataSet";
                    reportSourceExceptionPatientAntigenDiscrepancy.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportPatientAntigenDiscrepancy]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionPatientAntigenDiscrepancy);
            }
            else if (e.ReportPath == "ExceptionPatientTest" || e.DataSourceNames[0].ToString() == "ExceptionPatientTestDataSet")
            {
                ReportDataSource reportSourceExceptionPatientTest = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportPatientTest] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportPatientTest]).Tables.Count > 0)
                {
                    reportSourceExceptionPatientTest.Name = "ExceptionPatientTestDataSet";
                    reportSourceExceptionPatientTest.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportPatientTest]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionPatientTest);
            }
            else if (e.ReportPath == "ExceptionPatientTestInactivated" || e.DataSourceNames[0].ToString() == "ExceptionPatientTestInactivatedDataSet")
            {
                ReportDataSource reportSourceExceptionPatientTestInactivated = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportPatientTestInactivated] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportPatientTestInactivated]).Tables.Count > 0)
                {
                    reportSourceExceptionPatientTestInactivated.Name = "ExceptionPatientTestInactivatedDataSet";
                    reportSourceExceptionPatientTestInactivated.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportPatientTestInactivated]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionPatientTestInactivated);
            }
            else if (e.ReportPath == "ExceptionUnitAboRh" || e.DataSourceNames[0].ToString() == "ExceptionUnitAboRhDataSet")
            {
                ReportDataSource reportSourceExceptionUnitAboRh = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportUnitAboRh] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportUnitAboRh]).Tables.Count > 0)
                {
                    reportSourceExceptionUnitAboRh.Name = "ExceptionUnitAboRhDataSet";
                    reportSourceExceptionUnitAboRh.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportUnitAboRh]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionUnitAboRh);
            }
            else if (e.ReportPath == "ExceptionUnitModification" || e.DataSourceNames[0].ToString() == "ExceptionUnitModificationDataSet")
            {
                ReportDataSource reportSourceExceptionUnitModification = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportUnitModification] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportUnitModification]).Tables.Count > 0)
                {
                    reportSourceExceptionUnitModification.Name = "ExceptionUnitModificationDataSet";
                    reportSourceExceptionUnitModification.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportUnitModification]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionUnitModification);
            }
            else if (e.ReportPath == "ExceptionUnitSelection" || e.DataSourceNames[0].ToString() == "ExceptionUnitSelectionDataSet")
            {
                ReportDataSource reportSourceExceptionUnitSelection = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportUnitSelection] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportUnitSelection]).Tables.Count > 0)
                {
                    reportSourceExceptionUnitSelection.Name = "ExceptionUnitSelectionDataSet";
                    reportSourceExceptionUnitSelection.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportUnitSelection]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionUnitSelection);
            }
            else if (e.ReportPath == "ExceptionLabelMismatch" || e.DataSourceNames[0].ToString() == "ExceptionLabelMismatchDataSet")
            {
                ReportDataSource reportSourceExceptionLabelMismatch = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportLabelMismatch] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportLabelMismatch]).Tables.Count > 0)
                {
                    reportSourceExceptionLabelMismatch.Name = "ExceptionLabelMismatchDataSet";
                    reportSourceExceptionLabelMismatch.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportLabelMismatch]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionLabelMismatch);
            }
            else if (e.ReportPath == "ExceptionCautionTagBTRFPrinting" || e.DataSourceNames[0].ToString() == "ExceptionCautionTagBTRFPrintingDataSet")
            {
                ReportDataSource reportSourceExceptionCautionTagBTRFPrinting = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportCautionTagBTRFPrinting] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportCautionTagBTRFPrinting]).Tables.Count > 0)
                {
                    reportSourceExceptionCautionTagBTRFPrinting.Name = "ExceptionCautionTagBTRFPrintingDataSet";
                    reportSourceExceptionCautionTagBTRFPrinting.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportCautionTagBTRFPrinting]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionCautionTagBTRFPrinting);
            }
            else if (e.ReportPath == "ExceptionTrwSpecimen" || e.DataSourceNames[0].ToString() == "ExceptionTrwSpecimenDataSet")
            {
                ReportDataSource reportSourceExceptionTrwSpecimen = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportTrwSpecimen] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportTrwSpecimen]).Tables.Count > 0)
                {
                    reportSourceExceptionTrwSpecimen.Name = "ExceptionTrwSpecimenDataSet";
                    reportSourceExceptionTrwSpecimen.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportTrwSpecimen]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionTrwSpecimen);
            }
            else if (e.ReportPath == "ExceptionTransfusionReactionWorkup" || e.DataSourceNames[0].ToString() == "ExceptionTransfusionReactionWorkupDataSet")
            {
                ReportDataSource reportSourceExceptionTransfusionReactionWorkup = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportTransfusionReactionWorkup] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportTransfusionReactionWorkup]).Tables.Count > 0)
                {
                    reportSourceExceptionTransfusionReactionWorkup.Name = "ExceptionTransfusionReactionWorkupDataSet";
                    reportSourceExceptionTransfusionReactionWorkup.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportTransfusionReactionWorkup]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionTransfusionReactionWorkup);
            }
            else if (e.ReportPath == "ExceptionAntigenTest" || e.DataSourceNames[0].ToString() == "ExceptionAntigenTestDataSet")
            {
                ReportDataSource reportSourceExceptionAntigenTest = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportAntigenTest] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportAntigenTest]).Tables.Count > 0)
                {
                    reportSourceExceptionAntigenTest.Name = "ExceptionAntigenTestDataSet";
                    reportSourceExceptionAntigenTest.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportAntigenTest]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionAntigenTest);
            }
            else if (e.ReportPath == "ExceptionUnitTest" || e.DataSourceNames[0].ToString() == "ExceptionUnitTestDataSet")
            {
                ReportDataSource reportSourceExceptionUnitTest = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportUnitTest] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportUnitTest]).Tables.Count > 0)
                {
                    reportSourceExceptionUnitTest.Name = "ExceptionUnitTestDataSet";
                    reportSourceExceptionUnitTest.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportUnitTest]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionUnitTest);
            }
            else if (e.ReportPath == "ExceptionReturnIssuedUnit" || e.DataSourceNames[0].ToString() == "ExceptionReturnIssuedUnitDataSet")
            {
                ReportDataSource reportSourceExceptionReturnIssuedUnit = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportReturnIssuedUnit] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportReturnIssuedUnit]).Tables.Count > 0)
                {
                    reportSourceExceptionReturnIssuedUnit.Name = "ExceptionReturnIssuedUnitDataSet";
                    reportSourceExceptionReturnIssuedUnit.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportReturnIssuedUnit]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionReturnIssuedUnit);
            }
            else if (e.ReportPath == "ExceptionTransfusion" || e.DataSourceNames[0].ToString() == "ExceptionTransfusionDataSet")
            {
                ReportDataSource reportSourceExceptionTransfusion = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportTransfusion] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportTransfusion]).Tables.Count > 0)
                {
                    reportSourceExceptionTransfusion.Name = "ExceptionTransfusionDataSet";
                    reportSourceExceptionTransfusion.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportTransfusion]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionTransfusion);
            }
            else if (e.ReportPath == "ExceptionUnitSupply" || e.DataSourceNames[0].ToString() == "ExceptionUnitSupplyDataSet")
            {
                ReportDataSource reportSourceExceptionUnitSupply = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportUnitSupply] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportUnitSupply]).Tables.Count > 0)
                {
                    reportSourceExceptionUnitSupply.Name = "ExceptionUnitSupplyDataSet";
                    reportSourceExceptionUnitSupply.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportUnitSupply]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionUnitSupply);
            }
            else if (e.ReportPath == "ExceptionExpiredUnit" || e.DataSourceNames[0].ToString() == "ExceptionExpiredUnitDataSet")
            {
                ReportDataSource reportSourceExceptionExpiredUnit = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportExpiredUnitReceived] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportExpiredUnitReceived]).Tables.Count > 0)
                {
                    reportSourceExceptionExpiredUnit.Name = "ExceptionExpiredUnitDataSet";
                    reportSourceExceptionExpiredUnit.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportExpiredUnitReceived]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionExpiredUnit);
            }
            else if (e.ReportPath == "ExceptionUnitIssue" || e.DataSourceNames[0].ToString() == "ExceptionUnitIssueDataSet")
            {
                ReportDataSource reportSourceExceptionUnitIssue = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportUnitIssue] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportUnitIssue]).Tables.Count > 0)
                {
                    reportSourceExceptionUnitIssue.Name = "ExceptionUnitIssueDataSet";
                    reportSourceExceptionUnitIssue.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportUnitIssue]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionUnitIssue);
            }
            else if (e.ReportPath == "ExceptionPatientRestriction" || e.DataSourceNames[0].ToString() == "ExceptionPatientRestrictionDataSet")
            {
                ReportDataSource reportSourceExceptionPatientRestriction = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportPatientRestriction] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportPatientRestriction]).Tables.Count > 0)
                {
                    reportSourceExceptionPatientRestriction.Name = "ExceptionPatientRestrictionDataSet";
                    reportSourceExceptionPatientRestriction.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportPatientRestriction]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionPatientRestriction);
            }
            else if (e.ReportPath == "ExceptionUnitERIssuedTestingProblem" || e.DataSourceNames[0].ToString() == "ExceptionUnitERIssuedTestingProblemDataSet")
            {
                ReportDataSource reportSourceExceptionUnitERIssuedTestingProblem = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportUnitERIssuedTestingProblem] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportUnitERIssuedTestingProblem]).Tables.Count > 0)
                {
                    reportSourceExceptionUnitERIssuedTestingProblem.Name = "ExceptionUnitERIssuedTestingProblemDataSet";
                    reportSourceExceptionUnitERIssuedTestingProblem.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportUnitERIssuedTestingProblem]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionUnitERIssuedTestingProblem);
            }
            else if (e.ReportPath == "ExceptionExpiredOrder" || e.DataSourceNames[0].ToString() == "ExceptionExpiredOrderDataSet")
            {
                ReportDataSource reportSourceExceptionExpiredOrder = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportExpiredTaskProcessed] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportExpiredTaskProcessed]).Tables.Count > 0)
                {
                    reportSourceExceptionExpiredOrder.Name = "ExceptionExpiredOrderDataSet";
                    reportSourceExceptionExpiredOrder.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportExpiredTaskProcessed]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionExpiredOrder);
            }
            else if (e.ReportPath == "ExceptionRemoveFinalUnitStatus" || e.DataSourceNames[0].ToString() == "ExceptionRemoveFinalUnitStatusDataSet")
            {
                ReportDataSource reportSourceExceptionRemoveFinalUnitStatus = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportRemoveFinalUnitStatus] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportRemoveFinalUnitStatus]).Tables.Count > 0)
                {
                    reportSourceExceptionRemoveFinalUnitStatus.Name = "ExceptionRemoveFinalUnitStatusDataSet";
                    reportSourceExceptionRemoveFinalUnitStatus.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportRemoveFinalUnitStatus]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionRemoveFinalUnitStatus);
            }
            else if (e.ReportPath == "ExceptionInconclusiveCrossmatch" || e.DataSourceNames[0].ToString() == "ExceptionInconclusiveCrossmatchDataSet")
            {
                ReportDataSource reportSourceExceptionInconclusiveCrossmatch = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportCrossmatch] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportCrossmatch]).Tables.Count > 0)
                {
                    reportSourceExceptionInconclusiveCrossmatch.Name = "ExceptionInconclusiveCrossmatchDataSet";
                    reportSourceExceptionInconclusiveCrossmatch.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportCrossmatch]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionInconclusiveCrossmatch);
            }
            else if (e.ReportPath == "ExceptionElectronicTransfusion" || e.DataSourceNames[0].ToString() == "ExceptionElectronicTransfusionDataSet")
            {
                ReportDataSource reportSourceExceptionElectronicTransfusion = new ReportDataSource();
                if (_exceptionReports[Common.ExceptionReportType.ExceptionReportElectronicTransfusion] != null &&
                   ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportElectronicTransfusion]).Tables.Count > 0)
                {
                    reportSourceExceptionElectronicTransfusion.Name = "ExceptionElectronicTransfusionDataSet";
                    reportSourceExceptionElectronicTransfusion.Value = ((DataSet)_exceptionReports[Common.ExceptionReportType.ExceptionReportElectronicTransfusion]).Tables[0];
                }
                e.DataSources.Add(reportSourceExceptionElectronicTransfusion);
            }
        }

		private void btnPrint_Click(object sender, System.EventArgs e)
		{
            //CR 3449
            try
            {
                this.rvExceptionReport.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }

		private void btnClose_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

        private void FrmExceptionReport_Load(object sender, EventArgs e)
        {

            this.rvExceptionReport.RefreshReport();
        }

        private void rvExceptionReport_RenderingBegin(object sender, CancelEventArgs e)
        {
            this.btnPrint.Enabled = false;
        }

        private void rvExceptionReport_RenderingComplete(object sender, RenderingCompleteEventArgs e)
        {
            this.btnPrint.Enabled = true;
        }
	}
}

